% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optics.R
\name{OPTICSplot}
\alias{OPTICSplot}
\title{Visualisation of density-based clustering of spectral similarity data}
\usage{
OPTICSplot(distmat, eps = 10000, minPts = 3, eps_cl = 0.5, ...)
}
\arguments{
\item{distmat}{A distance matrix as generated by
\code{\link{distanceMatrix}}.}

\item{eps}{OPTICS parameters, see \code{\link[dbscan]{optics}}.}

\item{minPts}{OPTICS parameters, see \code{\link[dbscan]{optics}}.}

\item{eps_cl}{The reachability distance used for cluster determination,
see \code{\link[dbscan:optics]{extractDBSCAN}}.}

\item{...}{Additional graphical parameters to be passed to \code{plot()}}
}
\value{
A reachability distance plot as visualisation of OPTICS clustering,
see code{\link[dbscan:optics]{extractDBSCAN}}.
}
\description{
\code{OPTICSplot()} performs density-based clustering
of spectral similarity data using the OPTICS algorithm like
\code{\link{OPTICStbl}} and creates a reachability distance plot.
}
\details{
The function internally uses \code{\link[dbscan]{optics}}
and \code{\link[dbscan:optics]{extractDBSCAN}} from the \pkg{dbscan}
package.
}
\examples{
load(file = system.file("extdata",
    "distmat.RData",
    package = "CluMSIDdata"))

OPTICSplot(distmat[1:50,1:50], eps_cl = 0.7)

}
\seealso{
OPTICStbl
}
