% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gDNA.R
\name{plot_pca_heatmap}
\alias{plot_pca_heatmap}
\title{Check sample similarity and variation}
\usage{
plot_pca_heatmap(SummarizedCounts = NULL, silent = TRUE)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{silent}{A logical(1), specify whether to draw the plot. It is useful
to set it to FALSE useful when using the gtable output.}
}
\value{
A list of a ggplot object and a \code{\link[gtable:gtable]{gtable::gtable()}} object.
\describe{
\item{pca}{A \emph{ggplot} object containing the PCA score plot showing sample
similarity}
\item{heatmap}{A \emph{gtable} object containing the heatmap showing
pairwise sample distances}
}
}
\description{
Perform sample-level exploratory analysis of RNA-seq data, generating heatmap
showing sample distances and PCA plot showing sample variations. Internally,
DESeq2 is used for vst transformation of count data.
}
\examples{
\dontshow{if (require("patchwork") && require("ggplotify")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)
p<- plot_pca_heatmap(SummarizedCounts = sc,
                     silent = TRUE)
wrap_plots(p[["pca"]], as.ggplot(p[["heatmap"]]), ncol = 1)
\dontshow{\}) # examplesIf}
}
