% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{filter_reads}
\alias{filter_reads}
\title{Filter sequence reads in a FASTQ file by length}
\usage{
filter_reads(input, output, read_lengths = seq(21, 24), overwrite = TRUE)
}
\arguments{
\item{input}{A path to a FASTQ file targeted for filtering.}

\item{output}{A path to save the filtered reads in FASTQ format.}

\item{read_lengths}{A series of integers to specify read length.
Reads other than the length specified will be excluded
during alignment.}

\item{overwrite}{Overwrite the existing files if \code{TRUE}.}
}
\value{
A path to the filtered FASTQ file.
}
\description{
This function removes sequence reads with lengths outside
the specified range from the FASTQ file.
}
\details{
Studies on small RNA-seq data from viroid-infected plants
have mostly focused on reads with lengths ranging from 21 nt to 24 nt.
This function is intended to be used to
remove sequence reads with lengths outside the specified range.
The default range is 21-24 nt,
which can be changed through the \code{read_lengths} argument.

Note that, if filtering by read length has already been performed
during the quality control process,
there is no need to use this function.
}
\examples{
output_dpath <- tempdir()

fq <- system.file(package="CircSeqAlignTk", "extdata", "srna.fq.gz")
output_fq <- file.path(output_dpath, "sran.filtered.fq.gz")
filter_reads(fq, output_fq, seq(21, 24))
}
