% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{build_index}
\alias{build_index}
\title{Build indexes of reference sequences for alignment}
\usage{
build_index(
  input,
  output = NULL,
  n_threads = 1,
  overwrite = TRUE,
  aligner = c("hisat2", "bowtie2"),
  add_args = NULL
)
}
\arguments{
\item{input}{A path to a FASTA format file containing a reference sequence
of a genome for indexing.}

\item{output}{A path to a directory for saving the reference sequences and
indexes.}

\item{n_threads}{Number of threads to use for aligning reads.}

\item{overwrite}{Overwrite the existing files if \code{TRUE}.}

\item{aligner}{A string to specify the alignment for indexing.}

\item{add_args}{A string of additional arguments to be passed on to the
alignment tool directly (e.g., \code{--quiet}).}
}
\value{
A \code{\link{CircSeqAlignTkRefIndex-class}} object.
}
\description{
This function internally calls Bowtie2 or HISAT2
to build indexes of reference sequences for alignment preparation.
}
\details{
This function generates two types of reference sequences
from a genome and indexes them in preparation for alignment.
The type 1 reference sequence is identical to
the sequence provided by the \code{input} argument.
The type 2 reference sequence is generated
by restoring the type 1 reference sequence to a circular RNA
and opening the circle at the position opposite to that of type 1.
The type 1 and 2 reference sequences are then saved as FASTA format files,
\code{refseq.t1.fa} and \code{refseq.t2.fa}, respectively,
under the directory specified by the \code{output} argument.
Next, the function builds indexes for \code{refseq.t1.fa} and \code{refseq.t2.fa}.

Two alignment tools (Bowtie2 and HISAT2) can be specified for
building indexes through the aligner argument.
This function first attempts
to call the specified alignment tool
installed on the operation system directly;
however, if the tool is not installed,
then the function attempts to call
\code{\link[Rbowtie2]{bowtie2_build}} or
\code{\link[Rhisat2]{hisat2_build}} functions
implemented in the Rbowtie2 or Rhisat2 packages for indexing.
}
\examples{
output_dpath <- tempdir()

genome_seq <- system.file(package="CircSeqAlignTk", "extdata", "FR851463.fa")
ref_index <- build_index(input = genome_seq,
                         output = file.path(output_dpath, "index"))
}
\seealso{
\code{\link{CircSeqAlignTkRefIndex-class}}
}
