% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{table_enriched_genes_scExp}
\alias{table_enriched_genes_scExp}
\title{Creates table of enriched genes sets}
\usage{
table_enriched_genes_scExp(
  scExp,
  set = "Both",
  group = "C1",
  enr_class_sel = c("c1_positional", "c2_curated", "c3_motif", "c4_computational",
    "c5_GO", "c6_oncogenic", "c7_immunologic", "hallmark")
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object containing list of enriched gene
sets.}

\item{set}{A character vector, either 'Both', 'Overexpressed' or
'Underexpressed'. ('Both')}

\item{group}{The "group" name from differential analysis. Can be the cluster
name or the custom name in case of a custom differential analysis.}

\item{enr_class_sel}{Which classes of gene sets to show. (c('c1_positional',
'c2_curated', ...))}
}
\value{
A DT::data.table of enriched gene sets.
}
\description{
Creates table of enriched genes sets
}
\examples{
data("scExp")
\dontrun{table_enriched_genes_scExp(scExp)}

}
