% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{plot_reduced_dim_scExp_CNA}
\alias{plot_reduced_dim_scExp_CNA}
\title{Plot UMAP colored by Gain or Loss of cytobands}
\usage{
plot_reduced_dim_scExp_CNA(scExp, cytoBand)
}
\arguments{
\item{scExp}{A SingleCellExperiment with "gainOrLoss_cytoBand" reducedDim
slot filled. See  \code{\link{calculate_gain_or_loss}}}

\item{cytoBand}{Which cytoBand to color cells by}
}
\value{
Plot the gains/lost of the cytoband overlayed on the epigenetic UMAP.
}
\description{
Plot UMAP colored by Gain or Loss of cytobands
}
\examples{

data("scExp")
scExp = calculate_CNA(scExp,  control_samples = unique(scExp$sample_id)[1],
ref_genome="hg38", quantiles_to_define_gol = c(0.05,0.95))
plot_reduced_dim_scExp_CNA(scExp, get_most_variable_cyto(scExp)$cytoBand[1])

}
