\name{drawMapDendro}
\alias{drawMapDendro}

\title{ Draw a heatmap and dendrogram for a strand-specific data matrix
  generated by createChrMatrix }

\description{

  Given a data matrix, cluster by sample (if desired), and plot the
  dendrogram and heatmap along chromosome coordinates. This function
  reuses code from the gplots \code{heatmap.2} function. Note that this
  function makes assumptions about the current layout of the display
  device, and so should generally be called only via \code{plotChrMap}.

}
\usage{
drawMapDendro(x, start, end, col = "heat.colors", dendrogram = TRUE, Rowv = TRUE,
              margins = c(6, 6), na.rm=TRUE, hclustfun = hclust, distfun = dist,
              breaks, RowSideColors, cexRow, cexCol,
              xlab, ylab, labRow, labCol, na.color = 'gray', ...)
}
\arguments{

  \item{x}{The strand-specific data matrix to cluster and plot, usually
    generated using \code{createChrMatrix}.}

  \item{start}{The starting genome coordinate for the plot.}

  \item{end}{The ending genome coordinate for the plot.}

  \item{col}{A character vector of colors to use in the heat map, or the
    name of a function generating such a vector.}

  \item{dendrogram}{A boolean flag indicating whether or not to draw the
    dendrogram.}

  \item{Rowv}{Determines if and how the sample dendrogram should be
    reordered. If a \code{dendrogram}, then it is used "as-is", i.e.,
    without any reordering. If a vector of integers, then the dendrogram
    is computed and reordered based on the order of the vector. Set this
    argument to FALSE or NULL to draw the heatmap without any sample
    reordering.}

  \item{margins}{A numeric vector indicating the c(bottom, left) margins
    of the plot containing X and Y axes labels.}

  \item{na.rm}{Whether or not to remove NA from calculations.}

  \item{hclustfun}{Function used to compute the hierarchical clustering when
    \code{Rowv} is not a dendrogram object.  Defaults to \code{hclust}.}

  \item{distfun}{Function used to compute the distance (dissimilarity) between
    both rows and columns.  Defaults to \code{dist}.}

  \item{breaks}{(Optional) Either a numeric vector indicating the
    splitting points for binning \code{x} into colors, or a integer number of
    break points to be used, in which case the break points will be
    spaced equally between \code{min(x)} and \code{max(x)}.}

  \item{RowSideColors}{(Optional) Character vector of length \code{nrow(x)}
    containing the color names for a vertical side bar that may
    be used to annotate the rows of \code{x}.}

  \item{cexRow, cexCol}{(Optional) Positive numbers, used as
    \code{cex.axis} in for the row or column axis labeling. If these
    arguments are omitted the function will try and calculate a sane
    axis font size based on the number of rows or columns respectively.}

  \item{xlab, ylab}{X- and Y- axis titles; defaults to none.}

  \item{labRow, labCol}{Character vectors with row and column labels to
    use; these default to \code{rownames(x)} or \code{colnames(x)}, respectively.}

  \item{na.color}{Color to use for missing value (\code{NA}). Defaults
    to gray.}

  \item{...}{Additional arguments are passed to the \code{image} function.}

}
\details{
  This function makes assumptions about the plot layout, usually set by
  the enclosing \code{chrHeatMap} function. Typically neither of these
  functions should be called directly, but rather via the wrapper
  \code{plotChrMap} function.
}
\value{
  This function is executed for its side effects.
}
\author{ Tim F Rayner }
\seealso{
  \code{\link{plotChrMap}}, \code{\link{createChrMatrix}}, \code{\link{chrHeatMap}}
}
\examples{
data('demo')
stranddata <- createChrMatrix( chrdata, chr=22, strand='forward',
  start=21925000, end=24300000 )
layout(matrix(1:2, ncol=2), widths=c(0.1,1))
drawMapDendro( stranddata, margins=c(0,0) )
}
\keyword{hplot}

