% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOverlappingPeaks.R
\name{findOverlappingPeaks}
\alias{findOverlappingPeaks}
\alias{findOverlappingPeaks-deprecated}
\title{Find the overlapping peaks for two peak ranges.}
\usage{
findOverlappingPeaks(
  Peaks1,
  Peaks2,
  maxgap = -1L,
  minoverlap = 0L,
  multiple = c(TRUE, FALSE),
  NameOfPeaks1 = "TF1",
  NameOfPeaks2 = "TF2",
  select = c("all", "first", "last", "arbitrary"),
  annotate = 0,
  ignore.strand = TRUE,
  connectedPeaks = c("min", "merge"),
  ...
)
}
\arguments{
\item{Peaks1}{GRanges: See example below.}

\item{Peaks2}{GRanges: See example below.}

\item{maxgap, minoverlap}{Used in the internal call to \code{findOverlaps()}
to detect overlaps. See
\code{?\link[IRanges:findOverlaps-methods]{findOverlaps}} in the
\pkg{IRanges} package for a description of these arguments.}

\item{multiple}{TRUE or FALSE: TRUE may return multiple overlapping peaks in
Peaks2 for one peak in Peaks1; FALSE will return at most one overlapping
peaks in Peaks2 for one peak in Peaks1. This parameter is kept for backward
compatibility, please use select.}

\item{NameOfPeaks1}{Name of the Peaks1, used for generating column name.}

\item{NameOfPeaks2}{Name of the Peaks2, used for generating column name.}

\item{select}{all may return multiple overlapping peaks, first will return
the first overlapping peak, last will return the last overlapping peak and
arbitrary will return one of the overlapping peaks.}

\item{annotate}{Include overlapFeature and shortestDistance in the
OverlappingPeaks or not.  1 means yes and 0 means no. Default to 0.}

\item{ignore.strand}{When set to TRUE, the strand information is ignored in
the overlap calculations.}

\item{connectedPeaks}{If multiple peaks involved in overlapping in several
groups, set it to "merge" will count it as only 1, while set it to "min"
will count it as the minimal involved peaks in any concered groups}

\item{\dots}{Objects of \link[GenomicRanges:GRanges-class]{GRanges}: See
also \code{\link{findOverlapsOfPeaks}}.}
}
\value{
\item{OverlappingPeaks}{a data frame consists of input peaks
information with added information: overlapFeature (upstream: peak1 resides
upstream of the peak2; downstream: peak1 resides downstream of the peak2;
inside: peak1 resides inside the peak2 entirely; overlapStart: peak1
overlaps with the start of the peak2; overlapEnd: peak1 overlaps with the
end of the peak2; includeFeature: peak1 include the peak2 entirely) and
shortestDistance (shortest distance between the overlapping peaks)}
\item{MergedPeaks}{GRanges contains merged overlapping peaks}
}
\description{
Find the overlapping peaks for two input peak ranges.
}
\details{
The new function findOverlapsOfPeaks is recommended.

Efficiently perform overlap queries with an interval tree implemented in
IRanges.
}
\examples{

    if (interactive())
    {    
    peaks1 = 
        GRanges(seqnames=c(6,6,6,6,5), 
                IRanges(start=c(1543200,1557200,1563000,1569800,167889600),
                        end=c(1555199,1560599,1565199,1573799,167893599),
                        names=c("p1","p2","p3","p4","p5")),
                strand=as.integer(1))
    peaks2 = 
        GRanges(seqnames=c(6,6,6,6,5), 
                IRanges(start=c(1549800,1554400,1565000,1569400,167888600),
                        end=c(1550599,1560799,1565399,1571199,167888999),
                        names=c("f1","f2","f3","f4","f5")),
                strand=as.integer(1))
    t1 =findOverlappingPeaks(peaks1, peaks2, maxgap=1000, 
          NameOfPeaks1="TF1", NameOfPeaks2="TF2", select="all", annotate=1) 
    r = t1$OverlappingPeaks
    pie(table(r$overlapFeature))
    as.data.frame(t1$MergedPeaks)
    }

}
\references{
1.Interval tree algorithm from: Cormen, Thomas H.; Leiserson,
Charles E.; Rivest, Ronald L.; Stein, Clifford. Introduction to Algorithms,
second edition, MIT Press and McGraw-Hill. ISBN 0-262-53196-8

2.Zhu L.J. et al. (2010) ChIPpeakAnno: a Bioconductor package to annotate
ChIP-seq and ChIP-chip data. BMC Bioinformatics 2010, 11:237
doi:10.1186/1471-2105-11-237

3. Zhu L (2013). Integrative analysis of ChIP-chip and ChIP-seq dataset.  In
Lee T and Luk ACS (eds.), Tilling Arrays, volume 1067, chapter 4, pp. -19.
Humana Press. http://dx.doi.org/10.1007/978-1-62703-607-8_8
}
\seealso{
findOverlapsOfPeaks, annotatePeakInBatch, makeVennDiagram
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
