% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoGR.R
\docType{class}
\name{annoGR-class}
\alias{annoGR-class}
\alias{annoGR}
\alias{coerce}
\alias{coerce,GRanges,annoGR-method}
\alias{coerce,annoGR,GRanges-method}
\alias{info,annoGR-method}
\alias{info}
\alias{annoGR,GRanges-method}
\alias{annoGR,TxDb-method}
\alias{annoGR,EnsDb-method}
\title{Class \code{annoGR}}
\usage{
\S4method{info}{annoGR}(object)

\S4method{annoGR}{GRanges}(ranges, feature = "group", date, ...)

\S4method{annoGR}{TxDb}(
  ranges,
  feature = c("gene", "transcript", "exon", "CDS", "fiveUTR", "threeUTR", "microRNA",
    "tRNAs", "geneModel"),
  date,
  source,
  mdata,
  OrganismDb
)

\S4method{annoGR}{EnsDb}(
  ranges,
  feature = c("gene", "transcript", "exon", "disjointExons"),
  date,
  source,
  mdata
)
}
\arguments{
\item{object}{annoGR object.}

\item{ranges}{an object of \link[GenomicRanges:GRanges-class]{GRanges},
\link[GenomicFeatures:TxDb-class]{TxDb} or \link[ensembldb]{EnsDb}}

\item{feature}{annotation type}

\item{date}{a \link{Date} object}

\item{...}{could be following parameters}

\item{source}{character, where the annotation comes from}

\item{mdata}{data frame, metadata from annotation}

\item{OrganismDb}{an object of OrganismDb. It is used for extracting gene
symbol for geneModel group for \link[GenomicFeatures:TxDb-class]{TxDb}}
}
\description{
An object of class \code{annoGR} represents the annotation data could be
used by annotationPeakInBatch.
}
\section{Slots}{

\describe{
\item{\code{seqnames,ranges,strand,elementMetadata,seqinfo}}{slots inherit from 
\link[GenomicRanges:GRanges-class]{GRanges}. 
The ranges must have unique names.}

\item{\code{source}}{character, where the annotation comes from}

\item{\code{date}}{a \link{Date} object}

\item{\code{feature}}{annotation type, could be "gene", "exon", "transcript", "CDS",
"fiveUTR", "threeUTR", "microRNA", "tRNAs", "geneModel" for 
\link[GenomicFeatures:TxDb-class]{TxDb} object, or "gene", "exon",
"transcript" for \link[ensembldb]{EnsDb} object}

\item{\code{mdata}}{data frame, metadata from annotation}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("annoGR", date, elementMetadata, feature, mdata, ranges, seqinfo,
seqnames, source, strand)}
}

\examples{

    if(interactive() || Sys.getenv("USER")=="jianhongou"){
        library(EnsDb.Hsapiens.v79)
        anno <- annoGR(EnsDb.Hsapiens.v79)
    }

}
\author{
Jianhong Ou
}
\keyword{classes}
