% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-methods.R
\name{.diffExpr}
\alias{.diffExpr}
\title{Compute differential expression}
\usage{
.diffExpr(x, y, lod = NULL, alternative = "two.sided")
}
\arguments{
\item{x}{Feature expression in condition x}

\item{y}{Feature expression in condition y}

\item{lod}{Gene limit of detection}
}
\value{
A list containing the following components:

\item{\code{p.value}}{P-value}

\item{\code{fold}}{Fold-change}
}
\description{
Computes P-value and fold-change between two expression vectors.
}
\details{
For censored data a Peto-Peto test is performed,
for non-censored data a Wilcoxon rank sum test.
If limit of detection is provided, expectation maximization
is used to compute the fold-change.
}
\author{
Daniel C. Ellwanger
}
\keyword{internal}
