% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-BarcodeObj.R
\name{bc_subset}
\alias{bc_subset}
\alias{bc_merge}
\alias{bc_subset,BarcodeObj-method}
\alias{bc_merge,BarcodeObj,BarcodeObj-method}
\alias{+.BarcodeObj}
\alias{-.BarcodeObj}
\alias{*.BarcodeObj}
\title{Manages barcodes and samples in a BarcodeObj object}
\usage{
bc_subset(
  barcodeObj,
  sample = NULL,
  barcode = NULL,
  black_list = NULL,
  is_sample_quoted_exp = FALSE
)

bc_merge(barcodeObj_x, barcodeObj_y)

\S4method{bc_subset}{BarcodeObj}(
  barcodeObj,
  sample = NULL,
  barcode = NULL,
  black_list = NULL,
  is_sample_quoted_exp = FALSE
)

\S4method{bc_merge}{BarcodeObj,BarcodeObj}(barcodeObj_x, barcodeObj_y)

\method{+}{BarcodeObj}(barcodeObj_x, barcodeObj_y)

\method{-}{BarcodeObj}(barcodeObj, black_list)

\method{*}{BarcodeObj}(barcodeObj, white_list)
}
\arguments{
\item{barcodeObj}{A BarcodeObj object.}

\item{sample}{A character vector or integer vector or an expression
(expressio not applicable for \code{[]} operator), specifying the samples in
the subsets. When the value is an expression, the columns in the metadata can
be used as a variable.}

\item{barcode}{A vector of integer or string, indicating the selected
barcode.}

\item{black_list}{A character vector, specifying the black list with excluded
barcodes.}

\item{is_sample_quoted_exp}{A logical value. If TRUE, the expression in
\code{sample} argument will not be evaluated before executing the function.}

\item{barcodeObj_x}{A BarcodeObj object.}

\item{barcodeObj_y}{A BarcodeObj object.}

\item{white_list}{A character vector, giving the barcode white list.}
}
\value{
A BarcodeObj object.
}
\description{
A set of functions and operators for subsetting or joining of
BarcodeObj object(s). 
The \code{bc_subset}, \code{*} and \code{-} are used to select barcodes or
samples in a \code{BarcodeObj} object.
Two BarcodeObj objects can be joined by \code{+}.
}
\details{
\code{bc_subset} and \code{[]}: Gets samples and barcodes subset from a
\code{BarcodeObj} object.

\code{+}: Combines two \code{BarcodeObj} objects. The \code{metadata},
\code{cleanBc} and
\code{messyBc} slot in the BarcodeObj objects will be joined. 
For the \code{metadata} slot, the \code{sample_name} column, and the
\emph{Full outer join} (the record in either BarcodeObj object) will be
performed with row names as the key.
The \code{messyBc} and \code{cleanBc} from two objects are combined by rows
for the same sample from two \code{BarcodeObj} objects.

\code{-}: removes barcodes in the black_list.

\code{*}: selects barcodes in the white_list.
}
\examples{
data(bc_obj)

bc_obj

# Select barcodes
bc_subset(bc_obj, barcode = c("AACCTT", "AACCTT"))
bc_obj[c("AGAG", "AAAG"), ]

# Select samples by metadata
bc_meta(bc_obj)$phenotype <- c("l", "b")
bc_meta(bc_obj)
bc_subset(bc_obj, phenotype == "l")

# Select samples by sample name
bc_obj[, "test1"]
bc_obj[, c("test1", "test2")]
bc_subset(bc_obj, sample = "test1", barcode = c("AACCTT", "AACCTT"))

# Apply barcode blacklist
bc_subset(
bc_obj,
    sample = c("test1", "test2"),
    barcode = c("AACCTT"))

# Join two samples with different barcode sets
bc_obj["AGAG", "test1"] + bc_obj["AAAG", "test2"]

# Join two samples with overlap barcodes
bc_obj_join <- bc_obj["AGAG", "test1"] + bc_obj["AGAG", "test2"]
bc_obj_join
# The same barcode will be removed after applying bc_cure_depth()
bc_cure_depth(bc_obj_join)

# Remove barcodes
bc_obj
bc_obj - "AAAG"

# Select barcodes in a whitelist
bc_obj
bc_obj * "AAAG"
###
}
