% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAnalysis.R
\name{runAnalysis}
\alias{runAnalysis}
\title{Whole analysis of Regulatory Impact Factors (RIF) and Partial Correlation and Information Theory analysis (PCIT)}
\usage{
runAnalysis(
  mat,
  conditions = NULL,
  lfc = 2.57,
  padj = 0.05,
  TFs = NULL,
  nSamples1 = NULL,
  nSamples2 = NULL,
  tolType = "mean",
  diffMethod = "Reverter",
  data.type = NULL
)
}
\arguments{
\item{mat}{Count data where the rows are genes and coluns the samples (conditions).}

\item{conditions}{A vector of characters identifying the names of conditions (i.e. c('normal', 'tumor')).}

\item{lfc}{logFoldChange module threshold to define a gene as differentially expressed (default: 2.57).}

\item{padj}{Significance value to define a gene as differentially expressed (default: 0.05).}

\item{TFs}{A vector of character with all transcripts factors of specific organism.}

\item{nSamples1}{Number of samples that correspond to first condition.}

\item{nSamples2}{Number of samples that correspond to second condition.}

\item{tolType}{Tolerance calculation type (see \code{\link{tolerance}}) (default: 'mean').}

\item{diffMethod}{Method to calculate Differentially Expressed (DE) genes (see \code{\link{expDiff}}) (default: 'Reverter')}

\item{data.type}{Type of input data. If is \emph{expression} (FPKM, TPM, etc) or \emph{counts.}}
}
\value{
Returns an CeTF class object with output variables of each step of analysis.
}
\description{
This function uses RIF and PCIT algorithms to run the whole pipeline analysis.
The pipeline is composed by 4 steps:
\enumerate{
    \item \strong{Step 1:} Data adjustment;
    \item \strong{Step 2:} Differential expression analysis;
    \item \strong{Step 3:} Regulatory Impact Factors analysis;
    \item \strong{Step 4:} Partial Correlation and Information Theory analysis.
}
}
\examples{
data('simCounts')
out <- runAnalysis(mat = simCounts,
                   conditions=c('cond1', 'cond2'),
                   lfc = 3,
                   padj = 0.05,
                   TFs = paste0('TF_', 1:1000),
                   nSamples1 = 10,
                   nSamples2= 10,
                   tolType = 'mean',
                   diffMethod = 'Reverter',
                   data.type = 'counts')

}
\seealso{
\code{\link{CeTF-class}}
}
