% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroupGO.R
\name{getGroupGO}
\alias{getGroupGO}
\title{Functional Profile of a gene set at specific GO level}
\usage{
getGroupGO(genes, ont = "BP", keyType, annoPkg, level = 3)
}
\arguments{
\item{genes}{Character vector with the genes to perform the functional profile.}

\item{ont}{One of 'MF', 'BP', and 'CC' subontologies (default: 'BP').}

\item{keyType}{Key type of inputted genes (i.e. 'ENSEMBL', 'SYMBOL', 'ENTREZID').}

\item{annoPkg}{Package of annotation of specific organism (i.e. org.Hs.eg.db, org.Bt.eg.db, org.Rn.eg.db, etc).}

\item{level}{Specific GO Level (default: 3).}
}
\value{
Returns an list with the results of the functional profile of the genes and a
network with the ontologies (column 1) and the corresponding
genes (column 2).
}
\description{
Functional Profile of a gene set at specific GO level.
Given a vector of genes, this function will return the GO profile at
a specific level.
}
\examples{
\dontrun{ 
# load the annotation package
library(org.Hs.eg.db)

# load the CeTF class object resulted from runAnalysis function
data(CeTFdemo)

# getting the genes in network of condition 1
genes <- unique(c(as.character(NetworkData(CeTFdemo, 'network1')[, 'gene1']),
                 as.character(NetworkData(CeTFdemo, 'network1')[, 'gene2'])))

# performing getGroupGO analysis
cond1 <- getGroupGO(genes = genes,
                    ont = 'BP',
                    keyType = 'ENSEMBL',
                    annoPkg = org.Hs.eg.db, 
                    level = 3)
}


}
