% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustCoefPercentage.R
\name{clustCoefPercentage}
\alias{clustCoefPercentage}
\title{Calculate the clustering coefficient as a percentage}
\usage{
clustCoefPercentage(mat)
}
\arguments{
\item{mat}{An adjacency matrix. Calculating the clustering coefficient percentage only makes sense if some connections are zero i.e. no connection.}
}
\value{
Returns the clustering coefficient as a porcentage.
}
\description{
Given an adjacency matrix, calculate the clustering coefficient as a percentage of non-zero adjacencies.
}
\examples{
# loading a simulated counts data
data('simNorm')

# running PCIT analysis
results <- PCIT(simNorm)

# getting the clustering coefficient as percentage
clustCoefPercentage(results$adj_sig)

}
\references{
Nathan S. Watson-Haigh, Haja N. Kadarmideen, and Antonio Reverter (2010).
PCIT: an R package for weighted gene co-expression networks based on
partial correlation and information theory approaches. Bioinformatics.
26(3) 411-413. \url{https://academic.oup.com/bioinformatics/article/26/3/411/215002}
}
