% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RIFPlot.R
\name{RIFPlot}
\alias{RIFPlot}
\title{Relationship plots between RIF1, RIF2 and DE genes}
\usage{
RIFPlot(object, color = "darkblue", type = "RIF")
}
\arguments{
\item{object}{CeTF object resulted from \code{\link{runAnalysis}} function.}

\item{color}{Color of points (default: darkblue)}

\item{type}{Type of plot. The available options are: RIF or 
DE (default: RIF)}
}
\value{
Returns a relationship plot between RIF1 and RIF2 or a plot with the 
relationship between RIF1 or RIF2 with DE genes.
}
\description{
Generate plots for the relationship between the RIF output 
analysis (RIF1 and RIF2) and for differentially expressed genes (DE).
}
\details{
This function can only be used after using the \code{\link{runAnalysis}} 
function as it uses the CeTF class object as input.
}
\examples{
# load the CeTF class object resulted from runAnalysis function
data(CeTFdemo)

# performing RIFPlot for RIF
RIFPlot(object = CeTFdemo, 
        color  = 'darkblue', 
        type   = 'RIF')

        
# performing RIFPlot for DE
RIFPlot(object = CeTFdemo, 
        color  = 'darkblue', 
        type   = 'DE')

}
