% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakePredictionsFromCCG.r
\name{MakePredictionsFromCCG}
\alias{MakePredictionsFromCCG}
\title{make predictions from CCG}
\usage{
MakePredictionsFromCCG(hypothesisnode, signOfHypothesis, network, delta,
  nodesInExperimentalData = NULL)
}
\arguments{
\item{hypothesisnode}{a hypothesis node}

\item{signOfHypothesis}{the direction of change of hypothesis node}

\item{network}{a computational causal graph}

\item{delta}{the number of edges across which the hypothesis should be followed}

\item{nodesInExperimentalData}{the number of nodes in experimental data}
}
\value{
an matrix containing the relationship between each node and the hypothesis
}
\description{
Create a matrix of predictions for a particular hypothesis starting from a network 
with separate nodes for up- and down-regulation (+ve and -ve).
The output is an array containing the relationship between each node and the hypothesis.
The hypothesis provided will be the vertex id of one of the nodes in the network
(as an integer or name including + or - for up/down regulation).
The signOfHypothesis variable should be a 1 or -1, indicating up/down regulation.
(It generally shouldn't be necessary to reverse the sign of a node when working from
a CCG, but this facility is included for consistency with MakePredictionsFromCG)
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
ccg <- CreateCCG(network)
MakePredictionsFromCCG('NodeA', +1, ccg, 2)
}
\concept{
CausalR
}

