% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{predictAnnotation}
\alias{predictAnnotation}
\title{This function makes annotation predictions for a
set of genes based on gene sets (e.g., hallmark)
and a CatsCradle object by considering the annotations of
its neighboring genes.}
\usage{
predictAnnotation(
  genes,
  geneSets,
  fPrime,
  radius,
  metric = "umap",
  numPCs = NULL,
  normaliseByGeneSet = TRUE,
  normaliseByDistance = TRUE,
  normaliseToUnitVector = TRUE
)
}
\arguments{
\item{genes}{\itemize{
\item a character vector of genes
}}

\item{geneSets}{\itemize{
\item a set of annotations, e.g., hallmark
or GO
}}

\item{fPrime}{\itemize{
\item a Seurat object of genes SingleCellExperiment
to be converted to a Seurat object
}}

\item{radius}{\itemize{
\item radius for prediction neighborhood
}}

\item{metric}{\itemize{
\item reduction or NN, defaults to umap
}}

\item{numPCs}{\itemize{
\item used only if reduction is pca, defaults to NULL
}}

\item{normaliseByGeneSet}{\itemize{
\item determines whether vector annotations
are normalised by gene set size.  Defaults to TRUE
}}

\item{normaliseByDistance}{\itemize{
\item determines whether neighbor
contributions are normalised by edge weight.  Defaults to
TRUE.
}}

\item{normaliseToUnitVector}{\itemize{
\item determines whether to normalise
returned values to unit length.  Defaults to TRUE
}}
}
\value{
This returns a list of prediction vectors, one vector
for each gene in genes, each vector corresponding to the sets
in geneSets
}
\description{
This function makes annotation predictions for a
set of genes based on gene sets (e.g., hallmark)
and a CatsCradle object by considering the annotations of
its neighboring genes.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
STranspose_sce = getExample('STranspose_sce',toy=TRUE)
hallmark = getExample('hallmark',toy=TRUE)
set.seed(100)
genes = sample(colnames(STranspose),5)
predictions = predictAnnotation(genes,hallmark,STranspose,radius=.5)
predictions_sce = predictAnnotation(genes,hallmark,STranspose_sce,radius=.5)
}
