% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{getObjectSubsetClusteringPValue}
\alias{getObjectSubsetClusteringPValue}
\title{This function computes a p-value for the geometric
clustering of a gene set (in UMAP or PCA reduction)
based on the median distance from its complement to
the set.}
\usage{
getObjectSubsetClusteringPValue(
  fPrime,
  geneSubset,
  numTrials = 1000,
  reduction = "UMAP",
  numPCs = 10
)
}
\arguments{
\item{fPrime}{\itemize{
\item a transposed Seurat object, i.e. a
Seurat object of genes or SingleCellExperiment to
be converted to a Seurat object
}}

\item{geneSubset}{\itemize{
\item a subset of the genes which can
be given as a character vector as a logical vector
}}

\item{numTrials}{\itemize{
\item the number of random trials to be
carried out for randomised testing. Defaults to 1000.
}}

\item{reduction}{\itemize{
\item can be 'UMAP' or 'PCA', defaults
to 'UMAP'
}}

\item{numPCs}{\itemize{
\item number of PCs to use if reduction is
'PCA'
}}
}
\value{
A p-value reporting how often a random subset
of the same size is sufficiently clustered to produce
an equally large distance from its complement.
}
\description{
This function computes a p-value for the geometric
clustering of a gene set (in UMAP or PCA reduction)
based on the median distance from its complement to
the set.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose')
hallmark = getExample('hallmark',toy=TRUE)
geneSubset = intersect(colnames(STranspose),hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]])
p = getObjectSubsetClusteringPValue(STranspose,geneSubset,100)
}
