% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_main_CalibraCurve.R
\name{.saveTablesAndPlots}
\alias{.saveTablesAndPlots}
\title{Save result tables and plots}
\usage{
.saveTablesAndPlots(
  RES,
  output_path,
  pl_CC_list,
  pl_RF_list,
  summary_tab,
  CC_plot_width,
  CC_plot_height,
  RF_plot_width,
  RF_plot_height,
  plot_type,
  plot_dpi,
  device
)
}
\arguments{
\item{RES}{\strong{list} \cr Results of \code{\link{CalibraCurve}}. Each list
element is the result of \code{\link{calc_single_curve}}}

\item{output_path}{\strong{character(1)} \cr Folder to save results (table and
plots). If NULL (default), results are not saved.}

\item{pl_CC_list}{\strong{list} \cr List of calibration curves (ggplot objects,
results of \code{\link{plotCalibraCurve}} (CC_plot)).}

\item{pl_RF_list}{\strong{list} \cr List of response factor plots (ggplot objects,
results of \code{\link{plotResponseFactors}}).}

\item{summary_tab}{\strong{data.frame} \cr Table with summary information, result
of \code{\link{plotCalibraCurve}} (annotation_dat))}

\item{CC_plot_width}{\strong{numeric(1)} \cr Plot width in cm (default is 10).}

\item{CC_plot_height}{\strong{numeric(1)} \cr Plot height in cm (default is 10).}

\item{RF_plot_width}{\strong{numeric(1)} \cr Plot width in cm (default is 10).}

\item{RF_plot_height}{\strong{numeric(1)} \cr Plot height in cm (default is 10).}

\item{plot_type}{\strong{character(1)} \cr Type of plot for calibration curves:
"single_plots" (default, generate a separate plot for each substance),
"multiplot" (generate a graphic with subplots for each substance) or
"all_in_one" (generate a single plot with all substances).}

\item{plot_dpi}{\strong{numeric(1)} \cr Plot resolution in dpi (default is 300).}

\item{device}{\strong{character(1)} \cr Device for saving the plot (default is
"png"). Other options include "pdf", "jpeg", "tiff", "svg" etc. For
details see \code{\link[ggplot2]{ggsave}}.}
}
\value{
Invisible NULL. Plots and the summary table are saved to the hard drive.
}
\description{
Save result tables and plots
}
