% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_main_CalibraCurve.R
\name{CalibraCurve}
\alias{CalibraCurve}
\title{CalibraCurve}
\usage{
CalibraCurve(
  D_list,
  output_path = NULL,
  substance = "substance",
  minReplicates = 3,
  cvThres = 20,
  calcContinuousPrelimRanges = FALSE,
  weightingMethod = "1/x^2",
  centralTendencyMeasure = "mean",
  perBiasThres = 20,
  considerPerBiasCV = TRUE,
  perBiasDistThres = 10,
  RfThresL = 80,
  RfThresU = 120,
  plot_type = "single_plots",
  RF_colour_threshold = "orange",
  RF_colour_within = "#00BFC4",
  RF_colour_outside = "#F8766D",
  device = "png",
  CC_plot_width = 15,
  CC_plot_height = 10,
  RF_plot_width = 15,
  RF_plot_height = 10,
  plot_dpi = 300,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{D_list}{\strong{data.frame/list} \cr Data.frame or list of data.frames
(one for one specific substance, each must contain two columns:
Concentration and Measurement)}

\item{output_path}{\strong{character(1)} \cr Folder to save results (table and
plots). If NULL (default), results are not saved.}

\item{substance}{\strong{character(1)} \cr Name of the substance (default is
"substance1"). Will be added to the result files and may be used when
plotting multiple calibration curves in one plot.}

\item{minReplicates}{\strong{integer(1)} \cr Minimal number of replicates/data
points per concentration level. Concentration levels with too few data
points will be removed.}

\item{cvThres}{\strong{numeric(1)} \cr Threshold for CV per concentration level in
percent (default is 20).}

\item{calcContinuousPrelimRanges}{\strong{logical(1)} \cr If TRUE, the longest
continuous range is selected (default is TRUE). If FALSE, gaps with CVs
larger than the threshold may be included.}

\item{weightingMethod}{\strong{character(1)} \cr Method for weighting (currently
"1/x", "1/x^2" and "None" are supported, default is 1/x^2).}

\item{centralTendencyMeasure}{\strong{character(1)} \cr Method for calculating
average percent bias, "mean" (default) or "median".}

\item{perBiasThres}{\strong{numeric(1)} \cr Threshold for average percent bias in
percent, default is 20.}

\item{considerPerBiasCV}{\strong{logical(1)} \cr If TRUE, CV is considered for the
elimination of the concentration level (default). CV will only be
considered if the difference in percent bias values is lower than
perBiasDistThres.}

\item{perBiasDistThres}{\strong{numeric(1)} \cr Threshold for the difference in
average percent bias in percent (for lower differences, CV will be
considered), default is 10.}

\item{RfThresL}{\strong{numeric(1)} \cr Lower threshold for response factor in
percent (default is 80).}

\item{RfThresU}{\strong{numeric(1)} \cr Upper threshold for response factor in
percent (default is 120).}

\item{plot_type}{\strong{character(1)} \cr Type of plot for calibration curves:
"single_plots" (default, generate a separate plot for each substance),
"multiplot" (generate a graphic with subplots for each substance) or
"all_in_one" (generate a single plot with all substances).}

\item{RF_colour_threshold}{\strong{character(1)} \cr Response factor plot: Colour
for horizontal threshold lines, default is "orange".}

\item{RF_colour_within}{\strong{character(1)} \cr Response factor plot: Colour
for points and lines within the final linear range, default is "#00BFC4"
(default ggplot colour).}

\item{RF_colour_outside}{\strong{character(1)} \cr Response factor plot: Colour
for horizontal outside of the final linear range, default is "#F8766D"
(default ggplot colour).}

\item{device}{\strong{character(1)} \cr Device for saving the plot (default is
"png"). Other options include "pdf", "jpeg", "tiff", "svg" etc. For
details see \code{\link[ggplot2]{ggsave}}.}

\item{CC_plot_width}{\strong{numeric(1)} \cr Plot width in cm (default is 10).}

\item{CC_plot_height}{\strong{numeric(1)} \cr Plot height in cm (default is 10).}

\item{RF_plot_width}{\strong{numeric(1)} \cr Plot width in cm (default is 10).}

\item{RF_plot_height}{\strong{numeric(1)} \cr Plot height in cm (default is 10).}

\item{plot_dpi}{\strong{numeric(1)} \cr Plot resolution in dpi (default is 300).}

\item{verbose}{\strong{logical(1)} \cr If FALSE, no messages will be printed.}

\item{...}{additional parameters for \code{\link{plotCalibraCurve}}}
}
\value{
List with the following elements:
\itemize{
\item \code{RES}: List of CalibraCurve results (one item per substance, output
from \code{\link{calc_single_curve}}).
\item \code{summary_tab}: Data.frame with summary information about the
calibration curves, one row per substance.
\item \code{plot_CC_list}: List of ggplot2 objects of the calibration curves
(one per substance for "single_plots", otherwise only one item).
\item \code{plot_RF_list}: List of ggplot2 objects of the response factor plots
(one item).
}
}
\description{
CalibraCurve
}
\examples{
### NOTE: as output_path is not specified here, no files will be saved.
### Set output_path to a folder of your choice to save the results.

### single xlsx file:
data_path <- system.file("extdata", "MSQC1_xlsx", "GGPFSDSYR_QTRAP_y5.xlsx",
    package = "CalibraCurve")
D <- readDataTable(dataPath = data_path, concCol = 16, measCol = 12,
    fileType = "xlsx")
RES <- CalibraCurve(D_list = D)
RES$plot_CC_list
RES$plot_RF_list

### multiple xlsx files (in a folder) as multiplot:
data_folder <- system.file("extdata", "MSQC1_xlsx", package = "CalibraCurve")
D_list <- readMultipleTables(dataFolder = data_folder, fileType = "xlsx",
    concCol = 16, measCol = 12)
RES <- CalibraCurve(D_list = D_list, plot_type = "multiplot")
RES$plot_CC_list

### single rds file (SummarizedExperiment) as an all-in-one plot:
file <- system.file("extdata", "MSQC1", "msqc1_dil_GGPFSDSYR.rds",
    package = "CalibraCurve")
D_list <- readDataSE(dataPath = file, concColName = "amount_fmol",
        substColName = "Substance", assayNumber = 1)
RES <- CalibraCurve(D_list, plot_type = "all_in_one")
RES$plot_CC_list

}
