% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tomaftools.R
\name{tomaftools}
\alias{tomaftools}
\title{tomaftools}
\usage{
tomaftools(
  maf,
  clinicalData = NULL,
  rmFlags = FALSE,
  removeDuplicatedVariants = TRUE,
  useAll = TRUE,
  gisticAllLesionsFile = NULL,
  gisticAmpGenesFile = NULL,
  gisticDelGenesFile = NULL,
  gisticScoresFile = NULL,
  cnLevel = "all",
  cnTable = NULL,
  isTCGA = FALSE,
  vc_nonSyn = NULL,
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{clinicalData}{Clinical data associated with each 
# sample/Tumor_Sample_Barcode in MAF. Could be a text file or a data.frame. 
Default NULL. Inherited from maftools.}

\item{rmFlags}{Default FALSE. Can be TRUE or an integer. 
If TRUE, removes all the top 20 FLAG genes. 
If integer, remove top n FLAG genes. Inherited from maftools.}

\item{removeDuplicatedVariants}{removes repeated variants 
in a particuar sample, mapped to multiple transcripts of same Gene. 
See Description. Default TRUE. Inherited from maftools.}

\item{useAll}{logical. Whether to use all variants irrespective of values in 
Mutation_Status. Defaults to TRUE. If FALSE, only uses with values Somatic.
Inherited from maftools.}

\item{gisticAllLesionsFile}{All Lesions file generated by gistic. 
e.g; all_lesions.conf_XX.txt, where XX is the confidence level. Default NULL.
Inherited from maftools.}

\item{gisticAmpGenesFile}{Amplification Genes file generated by gistic. 
e.g; amp_genes.conf_XX.txt, where XX is the confidence level. Default NULL.
Inherited from maftools.}

\item{gisticDelGenesFile}{Deletion Genes file generated by gistic. 
e.g; del_genes.conf_XX.txt, where XX is the confidence level. Default NULL.
Inherited from maftools.}

\item{gisticScoresFile}{scores.gistic file generated by gistic. Default NULL
Inherited from maftools.}

\item{cnLevel}{level of CN changes to use. Can be 'all', 'deep' or 'shallow'.
Default uses all i.e, genes with both 'shallow' or 'deep' CN changes.
Inherited from maftools.}

\item{cnTable}{Custom copynumber data if gistic results are not available. 
Input file or a data.frame should contain three columns in aforementioned 
order with gene name, Sample name and copy number status 
(either 'Amp' or 'Del'). Default NULL. Inherited from maftools.}

\item{isTCGA}{Is input MAF file from TCGA source. 
If TRUE uses only first 12 characters from Tumor_Sample_Barcode.
Inherited from maftools.}

\item{vc_nonSyn}{NULL. Provide manual list of variant classifications to be 
considered as non-synonymous. Rest will be considered as silent variants. 
Default uses Variant Classifications with High/Moderate variant consequences. 
Inherited from maftools.}

\item{verbose}{TRUE logical. Default to be talkative and prints summary.
Inherited from maftools.}
}
\value{
An maf object that can be recognized by maftools.
}
\description{
Transform a CaMutQC maf object to a maftools maf object.
}
\examples{
maf_CaMutQC <- vcfToMAF(system.file("extdata/Multi-caller/",
package="CaMutQC"), multiVCF=TRUE)
maf_maftools <- tomaftools(maf_CaMutQC)
}
