% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterReg.R
\name{mutFilterReg}
\alias{mutFilterReg}
\title{mutFilterReg}
\usage{
mutFilterReg(
  maf,
  bedFile = NULL,
  bedHeader = FALSE,
  bedFilter = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{bedFile}{A bed file that contains region information.
Default: NULL}

\item{bedHeader}{Whether the input bed file has a header or not. 
Default: FALSE.}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: FALSE}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame where some variants
have R tag in CaTag column for region filtration.
}
\description{
Filter variants not in specific regions.
}
\examples{
maf <- vcfToMAF(system.file("extdata", "WES_EA_T_1_mutect2.vep.vcf",
package="CaMutQC"))
mafF <- mutFilterReg(maf, bedFile=system.file("extdata/bed/panel_hg38",
"Pan-cancer-hg38.rds", package="CaMutQC"), bedFilter = FALSE)
}
