% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_res.R
\docType{data}
\name{perm_res}
\alias{perm_res}
\title{Pre-computed permutation results for simulated data (\code{sim_FS})}
\format{
A list of objects returned from \code{CaDrA} function. The resulting 
object contains a list of key parameters that was used to run the
permutation-based testing, a vector of permuted best scores for 
a given n_perm, an observed best score, and a permuted p-value.

To visualize the Empirical Null Distribution of the permuted best scores over 
n_perm iterations, just pass the resulting list to \code{permutation_plot}.

See \code{permutation_plot} for more details.
}
\usage{
data(perm_res)
}
\value{
a list of objects returned from \code{CaDrA} function
}
\description{
The permutation result returned from \code{CaDrA} 
using pre-simulated dataset
(\code{FS = sim_FS}), pre-simulated input scores 
(\code{input_score = sim_Scores}), 
\code{top_N = 7}, \code{method = "ks_pval"}, \code{alternative = "less"}, 
\code{search_method = "both"}, \code{max_size = 10},
\code{obs_best_score = NULL} and \code{n_perm = 1000} 
as inputs to the function.
}
\examples{

# Load the pre-computed permutation results for sim_FS
data(perm_res)

# Plot the Empirical Null Distribution of the permuted best scores
# against its observed best score
permutation_plot(perm_res = perm_res)

}
\references{
Kartha VK, Kern JG, Sebastiani P, Zhang L,
Varelas X, Monti S (2017) CaDrA: A computational framework for performing
candidate driver analyses using binary genomic features.
(\href{https://www.frontiersin.org/articles/10.3389/fgene.2019.00121/full}{Frontiers in Genetics})
}
\keyword{datasets}
