% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_plot.R
\name{meta_plot}
\alias{meta_plot}
\title{Candidate Drivers Search Plot}
\usage{
meta_plot(topn_best_list, input_score_label = NULL, plot_title = NULL)
}
\arguments{
\item{topn_best_list}{a list of objects returned from \code{candidate_search} 
corresponding to the search of top N features given by top_N value.
The topn_best_list contains the best meta-feature matrix, its 
corresponding best score, its observed input scores, rank of the best 
features based on their scores, marginal best scores, and cumulative 
best scores.}

\item{input_score_label}{a label that references to the \code{input_score}
variable that was used to compute the top N best features. 
Default is \code{NULL}.}

\item{plot_title}{a title to the plot. Default is \code{NULL}.}
}
\value{
3 plots stacked on top of each other: 
1. a density diagram of observed input scores sorted from highest to lowest 
2. a tile plot of the top features within the meta-feature set 
3. a KS enrichment plot of the meta-feature set (this correspond to the 
logical OR of the features)
}
\description{
By utilizing the top N results obtained from \code{candidate_search},
we can find the best meta-feature among the top N searches using
\code{topn_best}. \code{meta_plot} is then used to produce graphics
including a tile plot for the top meta-features that associated with  
a molecular phenotype of interest (e.g. input_score), 
the KS enrichment plot of the meta-features, 
and lastly, a density diagram of the distribution of the observed
input scores sorted from largest to smallest at the top.
}
\examples{

# Load pre-computed Top-N list generated for sim_FS dataset
data(topn_list)

# With the results obtained from top-N evaluation,
# We can find the combination of features that gives the best score in
# top N searches
topn_best_meta <- topn_best(topn_list = topn_list)

# Now we can plot this set of best meta-feature
meta_plot(topn_best_list = topn_best_meta)

}
