% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{DAC_treated_cells}
\alias{DAC_treated_cells}
\title{DE genes with/without demethylating agent}
\format{
A \code{SummarizedExperiment} object with 24516 rows and 32 columns
\itemize{
\item Rows correspond to genes (ensembl_gene_id).
\item Columns correspond to samples.
\item Expression data correspond to counts that have been normalised
(by DESeq2 method) and log-transformed (log1p).
\item The colData contains the SRA references of the fastq files that
were downloaded, and informations about the cell lines and the
DAC treatment.
\item The rowData contains the results of a differential expression
evaluating the DAC treatment effect. For each each cell line, the
log2FC between treated and control cells is given, as well as the
p-adjusted value. The column \code{induced} flags genes significantly
induced (log2FoldChange >= 2 and padj <= 0.1) in at least one
cell line. The threshold is not too stringent as DAC is expected to induce
low expression levels (demethylation doesn't necessarily occurs in
all treated cells...).
When all cells lines already express the gene before DAC treatment, no
assessment of induction was done.
}
}
\source{
RNAseq

fastq files were downloaded from Encode database.  SRA reference of
samples are stored in the colData.
}
\description{
Gene expression values in a set of cell lines treated or not with
5-Aza-2'-Deoxycytidine (DAC), a demethylating agent.
}
\details{
Differential expression analysis was done using DESeq2_1.36.0,
using as \code{design = ~ treatment} (see
\code{scripts/make_DAC_treated_cells.R} for details).
}
