% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ctd.R
\name{download_ctd_chem}
\alias{download_ctd_chem}
\title{Function to download checmicals available in CTDbase}
\usage{
download_ctd_chem(verbose = FALSE, ask = TRUE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} is shows relevant
information of each step.}

\item{ask}{(default \code{TRUE}) If \code{TRUE} it asks the the persistent
location must be used.}
}
\value{
Passed name into \code{filename} argument if it could be download
\code{1} otherwise.
}
\description{
This function download the "Chemical vocabulary" file (\code{CTD_chemicals.tsv.gz})
from \code{http://ctdbase.org/downloads}.
}
\details{
The field included in the file (\code{CTD_chemicals.tsv.gz}) are:
\enumerate{
 \item ChemicalName
 \item ChemicalID (MeSH identifier)
 \item CasRN (CAS Registry Number, if available)
 \item Definition
 \item ParentIDs (identifiers of the parent terms; '|'-delimited list),
 \item TreeNumbers (identifiers of the chemical's nodes; '|'-delimited list),
 \item ParentTreeNumbers (identifiers of the parent nodes; '|'-delimited list),
 \item Synonyms ('|'-delimited list)
 \item DrugBankIDs ('|'-delimited list)
 }
}
\examples{
download_ctd_chem()
file.exists( "CTD_chemicals.tsv.gz" )
}
