% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{overlapNetworkPlot}
\alias{overlapNetworkPlot}
\title{Plot the overlaps as a network}
\usage{
overlapNetworkPlot(
  overlapDF,
  title = "Top overlaps network plot",
  nodeColor = "orange",
  edgeColor = "green4",
  ...
)
}
\arguments{
\item{overlapDF}{Overlap data frame.}

\item{title}{Plot title.}

\item{nodeColor}{The color of nodes. If \code{NULL}, the default
\code{henna::networkPlot} color scheme will be used, which uses different
colors for nodes belonging to different connected components.}

\item{edgeColor}{The color of edges.}

\item{...}{Additional parameters passed to \code{henna::networkPlot}.}
}
\value{
An overlap network plot.
}
\description{
This function plots the graph of the overlap data frame, with genes as
vertices and overlaps as edges.
}
\details{
A thin wrapper around \code{henna::networkPlot}.
}
\examples{
overlapDF <- data.frame(gene1 = paste0('G', c(1, 2, 5, 6, 7, 17)),
gene2 = paste0('G', c(2, 5, 8, 11, 11, 11)),
rank = c(1, 1, 3, 3, 3, 3))
overlapNetworkPlot(overlapDF)

}
