% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_depmap.R
\name{get_depmap_plot_data}
\alias{get_depmap_plot_data}
\title{Create DepMap dataframe for plotting}
\usage{
get_depmap_plot_data(gene, data.type, depmap.meta, depmap.pool)
}
\arguments{
\item{gene}{Character scalar of gene name.}

\item{data.type}{Character scalar of data type to retrieve. One of "dependency",
"crispr", "rnai", "cn", or "ccle_tpm".}

\item{depmap.meta}{data.frame of DepMap cell line metadata, as stored in the 'meta' table
of the SQLite database built by \code{\link{build_depmap_db}}.}

\item{depmap.pool}{pool connection to DepMap SQLite database built with \code{\link{build_depmap_db}}.}
}
\value{
data.frame containing appropriate DepMap data for plotting.
}
\description{
Based on the requested data type, this function will create a dataframe
from the DepMap database that can be used for plotting.
}
\examples{
\dontrun{
library(CRISPRball)
build_depmap_db(retrieve = c("meta", "crispr"))
pool <- pool::dbPool(RSQLite::SQLite(), dbname = "depmap_db.sqlite")
depmap.meta <- pool::dbGetQuery(pool, "SELECT * FROM 'meta'")

df <- get_depmap_plot_data(
    gene = "CDK2", data.type = "crispr",
    depmap.meta = depmap.meta, depmap.pool = pool
)
}
}
\seealso{
\code{\link{plot_depmap_lineages}}
}
\author{
Jared Andrews
}
