% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_survival_risk_group_f.R
\name{predict_survival_risk_group_f}
\alias{predict_survival_risk_group_f}
\title{Survival Risk Group Prediction Function}
\usage{
predict_survival_risk_group_f(
  selected_train_data,
  selected_test_data,
  Feature_List
)
}
\arguments{
\item{selected_train_data}{A data frame containing normalized expression data of selected features and survival information for
training set.}

\item{selected_test_data}{A data frame containing normalized expression data of selected features and survival information for
test set.}

\item{Feature_List}{A list of  features to be used for predicting the risk class in the
model.}
}
\value{
A list containing the following components:
\item{best_model}{The Best RF model.}
\item{Train_results}{Prediction resulst on Training data}
\item{Test_results}{Prediction resulst on Test data}
\item{misclassification_results}{Prediction results of best on model on training and Test data }
\item{All_tree_matrix}{Prediction results on training and test data based on all models using different number of trees }
}
\description{
This function builds a Random Forest (RF) model to classify samples into high-risk or low-risk survival groups
based on selected features.
}
\examples{
# Example usage of the predict_survival_risk_group_f function
data(Train_PI_data, package = "CPSM")
data(Test_PI_data, package = "CPSM")
data(Key_PI_list , package = "CPSM")
Results_Risk_group_Prediction<-  predict_survival_risk_group_f(selected_train_data = Train_PI_data,
selected_test_data = Test_PI_data, Feature_List = Key_PI_list )

}
