% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nomogram_generate_f.R
\name{Nomogram_generate_f}
\alias{Nomogram_generate_f}
\title{Nomogram Generation Function}
\usage{
Nomogram_generate_f(
  data,
  Feature_List,
  surv_time,
  surv_event,
  font_size = 0.8,
  axis_cex = 0.5,
  tcl_len = 0.5,
  label_margin = 0.5,
  col_grid = gray(c(0.85, 0.95))
)
}
\arguments{
\item{data}{A data frame containing survival information and predictor
variables. Must include columns for survival time, event status, and
selected features.}

\item{Feature_List}{A data frame or list containing the selected features
(column names) to be included in the nomogram.}

\item{surv_time}{A character string specifying the column name for survival
time in the input data.}

\item{surv_event}{A character string specifying the column name for survival
event status in the input data (1 for event, 0 for censored).}

\item{font_size}{Numeric. Base font size for the nomogram plot. Default is 0.8}

\item{axis_cex}{Numeric. Scaling factor for axis text size (cex.axis). Default is 0.5}

\item{tcl_len}{Numeric. Tick length on axes (tcl). Default is 0.5}

\item{label_margin}{Numeric. Margin for variable labels (lmgp). Default is 0.5}

\item{col_grid}{Color vector. Grid line colors for the nomogram plot. Default is gray(c(0.85, 0.95))}
}
\value{
A list containing:
\itemize{
\item \code{C_index_mat}: A matrix containing the bias-corrected and original C-index values.
}

The following steps are performed:
\itemize{
\item Validates input data and renames survival columns to standard names.
\item Prepares the data for modeling using \code{rms::datadist}.
\item Dynamically creates a Cox proportional hazards model formula.
\item Fits the Cox model using \code{rms::cph}.
\item Generates the nomogram with survival probabilities at specified
time points.
\item Validates the model and computes C-index values.
}
}
\description{
Nomogram Generation Function
}
\details{
The function dynamically creates a Cox proportional hazards model
based on the selected features and survival data. It computes survival
probabilities for 1, 3, 5, and 10 years (if applicable) and plots the
nomogram. The function uses internal validation with bootstrapping
(B = 1000) to calculate the bias-corrected C-index.
}
\examples{
data(Train_Data_Nomogram_input, package = "CPSM")
data(feature_list_for_Nomogram, package = "CPSM")
Nomogram_generate_f(
  data = Train_Data_Nomogram_input,
  Feature_List = feature_list_for_Nomogram,
  surv_time = "OS_month",
  surv_event = "OS",
  font_size = 0.8,
  axis_cex = 0.5,
  tcl_len = 0.5,
  label_margin = 0.5,
  col_grid = gray(c(0.85, 0.95))
)

}
