% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Installing_torch}
\alias{Installing_torch}
\title{Installing \code{torch} \code{R} library (on \code{WSL-Linux})}
\description{
A brief explanation of how to install the torch package on
\code{WSL2} (\verb{Windows Subsystem for Linux}), but it might work the same for
other \code{Linux} systems. Naturally it makes a difference whether one wants to
install support only for the \code{CPU} or also have the system \code{GPU} at the
ready!

These are just \emph{suggestions}, no guarantees are given:
\strong{try at your own peril!}

The main resources to install \code{torch} is
\url{https://torch.mlverse.org/docs/articles/installation.html} or
\url{https://cran.r-project.org/web/packages/torch/vignettes/installation.html}
}
\details{
For the \code{CPU}-only support one need to ensure that also numeric
libraries are installed, like \code{BLAS} and \code{LAPACK} and/or \code{MKL} if your
\code{CPU} is from \emph{Intel}. Otherwise \code{torch} will be stuck at using a single
core for all computations.

For the \code{GPU}, currently only \code{cuda} devices are supported. Moreover
only some specific versions of \code{cuda} (and corresponding \code{cudnn}) are
effectively usable, so one needs to install them to actually use the \code{GPU}.

As of today only \code{cuda} 12.8 is supported, but check the \code{torch}
documentation for more up-to-date information. Before downgrading your
\code{cuda} version, please be aware that it is possible to maintain separate
main versions of \code{cuda} at the same time on the system.

Below a link to install \code{cuda} 12.8 for \code{WSL2} given: use a local installer
to be sure the wanted \code{cuda} version is being installed, and not the latest
one: \href{https://developer.nvidia.com/cuda-12-8-0-download-archive?target_os=Linux&target_arch=x86_64&Distribution=WSL-Ubuntu&target_version=2.0&target_type=deb_local}{\code{cuda} 12.8 for \code{WSL2}}

It can happen that after the installation of the new \code{torch} version,
including the dependencies, \code{torch} actually fails to run claiming that
\code{lantern} dependency was not installed.
This can happen due to presence of old cache files, so one can simply
delete the relevant cache folder as in the example below...
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
  # find the relevant cache folder and delete it
  folder <- tools::R_user_dir("torch","cache")
  print(folder)
  unlink(folder, recursive = TRUE, force = TRUE)

  # reinstall explicitly for the toolchain you want
  torch::install_torch(cuda_version = "12.8", reinstall = TRUE)

  # run this only **AFTER** restarting `R`
  COTAN:::canUseTorch(TRUE, "cuda")
\dontshow{\}) # examplesIf}
}
