% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyCOMPASS.R
\name{shinyCOMPASS}
\alias{shinyCOMPASS}
\title{Start a Shiny Application for Visualizing COMPASS Results}
\usage{
shinyCOMPASS(
  x,
  dir = NULL,
  meta.vars,
  facet1 = "None",
  facet2 = "None",
  facet3 = "None",
  main = "Heatmap of Ag-Specificity Posterior Probabilities",
  stimulation = NULL,
  launch = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{COMPASSResult}.}

\item{dir}{A location to write out the \code{.rds} files that
will be loaded and used by the Shiny application.}

\item{meta.vars}{A character vector of column names that should be used
for potential facetting in the Shiny app. By default, we take all
metadata variables; you may want to limit this if you know certain
variables are not of interest.}

\item{facet1, facet2, facet3}{Default values for facets in the Shiny app.
Each should be the name of a single vector in the metadata.}

\item{main}{A title to give to the heatmap and subset histogram plots.}

\item{stimulation}{The name of the stimulation applied. If this is \code{NULL},
the stimulations used are inferred from the data (ie, the \code{COMPASS} call
used).}

\item{launch}{Boolean; if \code{TRUE} we launch the Shiny application.
Otherwise, the user can launch it manually by navigating to the directory
\code{dir} and running \code{shiny::runApp()}.}

\item{...}{Optional arguments passed to \code{shiny::runApp}.}
}
\description{
This function takes a \code{COMPASSResult} object, and generates
a local Shiny application for visualizing the results.
}
\examples{
if (interactive()) {
  oldOpt <- getOption("example.ask")
  options(example.ask=FALSE)
  on.exit( options(example.ask=oldOpt) )
  shinyCOMPASS(CR)
  options(example.ask=TRUE)
}
}
\seealso{
\code{\link{shinyCOMPASSDeps}}, for identifying packages that you
  need in order to run the Shiny application.
}
