% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNVMetricsLog2ratioInternalMethods.R
\encoding{UTF-8}
\name{calculateOneLog2valueMetricT}
\alias{calculateOneLog2valueMetricT}
\title{Calculate metric using the log2ratio values between two samples.}
\usage{
calculateOneLog2valueMetricT(
  entry,
  segmentData,
  method,
  minThreshold,
  bedExclusion
)
}
\arguments{
\item{entry}{a \code{list} which contains the row and column indexes
(always in this order) of
the metric in the final matrix. Those values correspond to the positions
of the two samples used
to calculate the metric in the \code{GRangesList} (\code{segmentData}).}

\item{segmentData}{a \code{GRangesList} that contains a collection of
genomic ranges representing copy number events, including amplified/deleted
status, from at least 2 samples. All samples must have a metadata column
called '\code{log2ratio}' with the log2ratio values.}

\item{method}{a \code{character} string representing the metric to be
used ('\code{weightedEuclideanDistance}').}

\item{minThreshold}{a single \code{numeric} setting the minimum value
to consider two segments as different during the metric calculation. If the
absolute difference is below or equal to threshold, the difference will be
replaced by zero.}

\item{bedExclusion}{an optional \code{GRanges} containing the regions
that have to be excluded for the metric calculation or \code{NULL}.}
}
\value{
a \code{list} containing 1 entry:
\itemize{
 \item{\code{metric} a \code{data.frame}, which contains 3 columns. The 2
first columns, called \code{row} and \code{column} correspond to the
indexes of the metric in the final matrix. Those
2 first columns match to the \code{entry} parameter. The third column,
called \code{metric},
contains the values of the specified metric for each combination.
If the metric cannot be calculated, \code{NA} is present. }
}
}
\description{
Calculate a specific metric using the level of
amplification/deletion, in log2 ratio, between two samples.
}
\details{
The method calculates a specified metric using overlapping
regions between the samples. Only regions corresponding to the type
specified by user are used in the calculation of the metric. The strand of
the regions is not taken into account while
calculating the metric.

The Sorensen metric is calculated by dividing twice the size of
the intersection by the sum of the size of the two sets. If the sum of
the size of the two sets is zero; the value \code{NA} is
returned instead.
}
\examples{

## Load required package to generate the two samples
require(GenomicRanges)

## Create a GRangesList object with 3 samples
## The stand of the regions doesn't affect the calculation of the metric
demo <- GRangesList()

## Generate two samples with log2value information as a metadata column
demo[["sample01"]]  <- GRanges(seqnames="chr1",
    ranges=IRanges(start=c(100, 201, 400),
    end=c(200, 350, 500)), strand="*",
    log2ratio=c(1.1111, 2.2222, -0.9999))
demo[["sample02"]] <- GRanges(seqnames="chr1",
    ranges=IRanges(start=c(150, 200, 450),
    end=c(250, 350, 500)), strand="*",
    log2ratio=c(2.2121, 1.1212, -1.3939))

## The 2 samples used to calculate the metric
entries <- data.frame(row=c(2), col=c(1))

## Calculate weighted Euclidean distance
CNVMetrics:::calculateOneLog2valueMetricT(entry=entries,
    segmentData=demo, method="weightedEuclideanDistance",
    minThreshold=0.2, bedExclusion=NULL)


}
\author{
Astrid Deschênes
}
\keyword{internal}
