% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNVMetricsSimulations.R
\encoding{UTF-8}
\name{processSim}
\alias{processSim}
\title{Generate simulated samples with copy number profiles derived from
a specific sample}
\usage{
processSim(curSample, nbSim)
}
\arguments{
\item{curSample}{a \code{GRanges} that contains a collection of
genomic ranges representing copy number events, including amplified/deleted
status, from one sample. The sample must have a metadata column
called '\code{state}' with a state, in an character string format,
specified for each region (ex: DELETION, LOH, AMPLIFICATION, NEUTRAL, etc.)
and a metadata column called '\code{CN}' that contains the log2 copy
number ratios.}

\item{nbSim}{a single positive \code{integer} which is corresponding to the
number of simulations that will be generated.}
}
\value{
a \code{data.frame} containing the segments for each
simulated sample. The \code{data.frame} has 6 columns:
\itemize{
\item{\code{ID}}{ a \code{character} string, the name of the simulated
sample }
\item{\code{chr}}{ a \code{character} string, the name fo the chromosome }
\item{\code{start}}{ a \code{integer}, the starting position of the
segment }
\item{\code{end}}{ a \code{integer}, the ending position of the segment }
\item{\code{log2ratio}} { a \code{numerical}, the log2 copy number
ratio assigned to the segment }
\item{\code{state}} { a \code{character} string, the state of the segment
(ex: DELETION, AMPLIFICATION, NEUTRAL, etc.) }
}
}
\description{
The function uses the input sample to
simulate new samples. The simulated samples will possess similar
sizes of events, proportional to the original chromosome.
To generate realistic simulations, the specified sample
must contain segments covering the majority of the genome. Most
importantly, the NEUTRAL segments should be present.
}
\details{
TODO
}
\examples{

## Load required package to generate the sample
require(GenomicRanges)

## Create one 'demo' genome with 2 chromosomes and few segments
## The stand of the regions doesn't affect the calculation of the metric
sample01 <- GRanges(seqnames=c(rep("chr1", 4), rep("chr2", 3)),
    ranges=IRanges(start=c(1905048, 4554832, 31686841, 32686222,
        1, 120331, 725531),
    end=c(2004603, 4577608, 31695808, 32689222, 117121,
        325555, 1225582)),
    strand="*",
    state=c("AMPLIFICATION", "NEUTRAL", "DELETION", "LOH",
        "DELETION", "NEUTRAL", "NEUTRAL"),
    log2ratio=c(0.5849625, 0, -1, -1, -0.87777, 0, 0))

## Generates 10 simulated genomes based on the 'demo' genome
simRes <- processSim(curSample=sample01, nbSim=10)

}
\author{
Astrid Deschênes, Pascal Belleau
}
