% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{computeUPW}
\alias{computeUPW}
\title{Up weights computation}
\usage{
computeUPW(g, freqs, no.of.children, A)
}
\arguments{
\item{g}{graph (a Directed Acyclic Graph)}

\item{freqs}{observed genotype frequencies}

\item{no.of.children}{number of children for each node}

\item{A}{adjacency matrix of G}
}
\value{
a vector containing the Up weights for each edge
}
\description{
Computes the up weights formula using
a Dinamic Programming approach (starting call),
see vignettes for further explaination.
}
\examples{
require(dplyr)
require(igraph)
preproc <- example_dataset() \%>\% dataset_preprocessing
samples <- preproc[["samples"]]
freqs   <- preproc[["freqs"]]
labels  <- preproc[["labels"]]
genes   <- preproc[["genes"]]
g <- graph_non_transitive_subset_topology(samples, labels)
# prepare adj matrix
A <- as.matrix(as_adj(g))
# pre-compute exiting edges from each node
no.of.children <- get_no_of_children(A,g)
computeUPW(g, freqs, no.of.children, A)

}
