% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{get_cemitool_r2_beta}
\alias{get_cemitool_r2_beta}
\alias{get_cemitool_r2_beta,CEMiTool-method}
\title{Calculate CEMiTool beta and R2 values}
\usage{
get_cemitool_r2_beta(cem, ...)

\S4method{get_cemitool_r2_beta}{CEMiTool}(cem, eps = 0.1)
}
\arguments{
\item{cem}{A CEMiTool object containing the fit_indices slot}

\item{...}{Optional parameters.}

\item{eps}{A value indicating the accepted interval between successive
   values of R squared to use to calculate the selected beta.
Default: 0.1.}
}
\value{
A vector containing R squared value and the chosen beta parameter.
}
\description{
This function takes a CEMiTool object with beta data and returns
a vector containing the chosen beta and corresponding R squared value.
}
\examples{
# Get example expression data
data(expr0)
# Initialize new CEMiTool object with expression data
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Get modules and beta data
cem <- find_modules(cem)
# Get CEMiTool R2 and beta values
get_cemitool_r2_beta(cem)

}
