% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{expr0}
\alias{expr0}
\title{Yellow Fever gene expression data from GEO study GSE13485}
\format{
An object of class \code{data.frame}
}
\source{
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=gse13485}{GEO}
}
\usage{
data(expr0)
}
\description{
Modified data from a yellow fever vaccination study by Querec et al, 2009.
In order to reduce package size, only the 4000 genes with the highest 
variance were selected for this dataset.
}
\examples{
data(expr0)
# Run CEMiTool analysis
\dontrun{cemitool(expr0)}
}
\references{
Querec TD, Akondy RS, Lee EK, Cao W et al. Systems biology 
approach predicts immunogenicity of the yellow fever vaccine in humans. 
Nat Immunol 2009 Jan;10(1):116-25. PMID: 19029902
\href{https://www.ncbi.nlm.nih.gov/pubmed/19029902}{PubMed}
}
\keyword{datasets}
