% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExprs.R
\name{plotExprs}
\alias{plotExprs}
\title{Expression densities}
\usage{
plotExprs(x, features = NULL, color_by = "condition", assay = "exprs")
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{features}{character vector specifying 
which features to invlude; valid values are 
\code{"type"/"state"} for \code{type/state_markers(x)} 
if \code{rowData(x)$marker_class} have been specified; 
a subset of \code{rownames(x)}; NULL to use all features.}

\item{color_by}{character string specifying 
a non-numeric cell metadata column by which 
to color density curves for each sample; 
valid values are \code{names(colData(x))}.}

\item{assay}{character string specifying which assay data 
to use; valid values are \code{assayNames(x)}.}
}
\value{
a \code{\link{ggplot}} object.
}
\description{
Plots smoothed densities of marker intensities, with a density curve for 
each sample ID, and curves colored by a cell metadata variable of interest.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
plotExprs(sce)

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
