% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiffHeatmap.R
\name{plotDiffHeatmap}
\alias{plotDiffHeatmap}
\title{Plot differential heatmap}
\usage{
plotDiffHeatmap(
  x,
  y,
  k = NULL,
  top_n = 20,
  fdr = 0.05,
  lfc = 1,
  all = FALSE,
  sort_by = c("padj", "lfc", "none"),
  y_cols = list(padj = "p_adj", lfc = "logFC", target = "marker_id"),
  assay = "exprs",
  fun = c("median", "mean", "sum"),
  normalize = TRUE,
  col_anno = TRUE,
  row_anno = TRUE,
  hm_pal = NULL,
  fdr_pal = c("lightgrey", "lightgreen"),
  lfc_pal = c("blue3", "white", "red3")
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{y}{a \code{SummarizedExperiment} containing differential testing
results as returned by one of \code{\link[diffcyt]{testDA_edgeR}}, 
\code{\link[diffcyt]{testDA_voom}}, \code{\link[diffcyt]{testDA_GLMM}}, 
\code{\link[diffcyt]{testDS_limma}}, or \code{\link[diffcyt]{testDS_LMM}}.
Alternatively, a list as returned by \code{\link[diffcyt]{diffcyt}}.}

\item{k}{character string specifying 
the clustering in \code{x} from which \code{y} was obtained.
If NULL, \code{plotDiffHeatmap} will try and guess it,
which will be inaccurate if multiple clusterings share the same levels.}

\item{top_n}{numeric. Number of top clusters (if \code{type = "DA"})
or cluster-marker combinations (if \code{type = "DS"}) to display.}

\item{fdr}{numeric threshold on adjusted p-values below which 
results should be retained and considered to be significant.}

\item{lfc}{numeric threshold on logFCs above which to retain results.}

\item{all}{logical specifying whether all \code{top_n} results should 
be displayed. If \code{TRUE}, \code{fdr,lfc} filtering is skipped.}

\item{sort_by}{character string specifying the \code{y} column to sort by; 
\code{"none"} to retain original ordering. Adj. p-values will increase, 
logFCs will decreasing from top to bottom.}

\item{y_cols}{named list specifying columns in \code{y} that contain
adjusted p-values (\code{padj}), logFCs (\code{lfc}) and, 
for DS results, feature names (\code{target}).
When only some \code{y_cols} differ from the defaults,
specifying only these is sufficient.}

\item{assay}{character string specifying which assay 
data to use; valid values are \code{assayNames(x)}.}

\item{fun}{character string specifying the function to use 
as summary statistic for aggregation of \code{assay} data.}

\item{normalize}{logical specifying whether Z-score normalized values 
should be plotted. If \code{y} contains DA analysis results, 
frequencies will be arcsine-square-root scaled prior to normalization.}

\item{col_anno}{logical specifying whether to include column annotations 
for all non-numeric cell metadata variables; or a character vector 
in \code{names(colData(x))} to include only a subset of annotations.
(Only variables that map uniquely to each sample will be included)}

\item{row_anno}{logical specifying whether to include a row annotation 
indicating whether cluster (DA) or cluster-marker combinations (DS) 
are significant, labeled with adjusted p-values, as well as logFCs.}

\item{hm_pal}{character vector of colors 
to interpolate for the heatmap. Defaults to \code{brewer.pal}'s 
\code{"RdYlBu"} for DS, \code{"RdBu"} for DA results heatmaps.}

\item{fdr_pal, lfc_pal}{character vector of colors to use for row annotations
\itemize{
\item{\code{fdr_pal}}{length 2 for (non-)significant at given \code{fdr}}
\item{\code{lfc_pal}}{length 3 for negative, zero and positive}}}
}
\value{
a \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Heatmaps summarizing differental abundance 
& differential state testing results.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce, verbose = FALSE)

## differential analysis
library(diffcyt)

# create design & constrast matrix
design <- createDesignMatrix(ei(sce), cols_design=2:3)
contrast <- createContrast(c(0, 1, 0, 0, 0))

# test for
# - differential abundance (DA) of clusters
# - differential states (DS) within clusters

da <- diffcyt(sce, design = design, contrast = contrast, 
    analysis_type = "DA", method_DA = "diffcyt-DA-edgeR",
    clustering_to_use = "meta20", verbose = FALSE)
    
ds <- diffcyt(sce, design = design, contrast = contrast, 
    analysis_type = "DS", method_DS = "diffcyt-DS-limma",
    clustering_to_use = "meta20", verbose = FALSE)
    
# extract result tables
da <- rowData(da$res)
ds <- rowData(ds$res)
    
# display test results for
# - top DA clusters
# - top DS cluster-marker combinations
plotDiffHeatmap(sce, da)
plotDiffHeatmap(sce, ds)

# visualize results for subset of clusters
sub <- filterSCE(sce, cluster_id \%in\% seq_len(5), k = "meta20")
plotDiffHeatmap(sub, da, all = TRUE, sort_by = "none")

# visualize results for selected feature
# & include only selected annotation
plotDiffHeatmap(sce["pp38", ], ds, col_anno = "condition", all = TRUE)

}
\author{
Lukas M Weber & Helena L Crowell \email{helena.crowell@uzh.ch}
}
