% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{ranges2genes}
\alias{ranges2genes}
\title{ranges2genes}
\usage{
ranges2genes(ranges, genes)
}
\arguments{
\item{ranges}{\code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} object, for example extracted from
a \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}} object with the
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::rowRanges}} command.}

\item{genes}{A \emph{GRanges} object containing \code{gene_name} metadata.}
}
\value{
A \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}} factor of same length as the \emph{GRanges} object,
indicating one gene symbol or a semicolon-separated list of gene symbols for each
range.  The levels are alphabetically sorted.
}
\description{
Assign gene symbol(s) to Genomic Ranges.
}
\details{
This private (non-exported) function is used to assign gene symbols
to genomic ranges.  It is run by \code{\link{annotateCTSS}}, which has to
be run before \code{\link{CTSStoGenes}}.
}
\examples{
CAGEr:::ranges2genes(CTSScoordinatesGR(exampleCAGEexp), exampleZv9_annot)

}
\seealso{
\code{\link{CTSScoordinatesGR}}, \code{\link{exampleZv9_annot}}

Other CAGEr annotation functions: 
\code{\link{annotateCTSS}()},
\code{\link{plotAnnot}()},
\code{\link{ranges2annot}()},
\code{\link{ranges2names}()}

Other CAGEr gene expression analysis functions: 
\code{\link{CTSStoGenes}()},
\code{\link{GeneExpDESeq2}()}
}
\author{
Charles Plessy
}
\concept{CAGEr annotation functions}
\concept{CAGEr gene expression analysis functions}
