% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResetMethods.R
\name{mergeCAGEsets}
\alias{mergeCAGEsets}
\alias{mergeCAGEsets,CAGEexp,CAGEexp-method}
\title{Merge two CAGEr objects into one}
\usage{
mergeCAGEsets(cs1, cs2)

\S4method{mergeCAGEsets}{CAGEexp,CAGEexp}(cs1, cs2)
}
\arguments{
\item{cs1}{A \code{CAGEr} object}

\item{cs2}{A \code{CAGEr} object}
}
\value{
Note that merging discards all other information present in the
two \code{CAGEr} objects, that is, the merged object will not contain any
normalised tag counts, CTSS clusters, quantile positions, etc., so these
have to be calculated again by calling the appropriate functions on the
merged object.  Also, it is only possible to merge two objects that contain
TSS information for the same reference genome and do not share any sample
names.

Returns a \code{CAGEexp} object, which contains a union of
TSS positions present in the two input objects and raw tag counts for those
TSSs in all samples from both input objects.
}
\description{
Merges two \code{\link{CAGEr}} objects into one by combining the CTSS genomic
coordinates and raw tag counts.  The resulting object will contain a union
of TSS positions present in the two input objects and raw tag counts for
those TSSs in all samples from both input objects.
}
\examples{
library(BSgenome.Drerio.UCSC.danRer7)

pathsToInputFiles <- system.file("extdata", c("Zf.unfertilized.egg.chr17.ctss",
  "Zf.30p.dome.chr17.ctss", "Zf.prim6.rep1.chr17.ctss"), package="CAGEr")
  
ce1 <- CAGEexp(genomeName = "BSgenome.Drerio.UCSC.danRer7",
inputFiles = pathsToInputFiles[1:2], inputFilesType = "ctss", sampleLabels =
c("sample1", "sample2"))
ce1 <- getCTSS(ce1)

ce2 <- CAGEexp(genomeName = "BSgenome.Drerio.UCSC.danRer7",
inputFiles = pathsToInputFiles[3], inputFilesType = "ctss", sampleLabels =
"sample3")

ce2 <- getCTSS(ce2)

ce <- mergeCAGEsets(ce1, ce2)

}
\seealso{
\code{\link{CAGEexp}}
}
\author{
Vanja Haberle

Charles Plessy
}
