% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{CTSStagCountDF}
\alias{CTSStagCountDF}
\alias{CTSStagCountDF,CAGEexp-method}
\alias{CTSStagCountGR}
\alias{CTSStagCountGR,CAGEexp-method}
\alias{CTSStagCountSE}
\alias{CTSStagCountSE,CAGEexp-method}
\title{Raw CAGE TSSs expression counts}
\usage{
CTSStagCountDF(object)

\S4method{CTSStagCountDF}{CAGEexp}(object)

CTSStagCountGR(object, samples)

\S4method{CTSStagCountGR}{CAGEexp}(object, samples)

CTSStagCountSE(object)

\S4method{CTSStagCountSE}{CAGEexp}(object)
}
\arguments{
\item{object}{A \code{CAGEexp} object.}

\item{samples}{For \code{CTSStagCountGR} only: name(s) or number(s) identifying
sample(s) or "all" to return a \code{GRangesList} of all the samples.}
}
\value{
Returns an object with number of CAGE tags supporting each TSS
(rows) in every CAGE dataset (columns).  The class of the object depends on the
function being called:
\itemize{
\item \code{CTSStagCountDF}: A \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} of \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}} integers.
\item \code{CTSStagCountSE}: A \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}}\verb{containing a}DataFrame\code{of}Rle` integers.
\item \code{CTSStagCountGR}: A \code{CTSS} object (wrapping \code{GRanges}) containing a \code{score}
column indicating expression values for a given sample, or a
\code{GRangesList} of \code{CTSS} objects.
}
}
\description{
Extracts the tag count for all detected TSSs in all CAGE datasets
from \code{\link{CAGEexp}} objects.
}
\examples{
CTSStagCountDF(exampleCAGEexp)
 
CTSStagCountGR(exampleCAGEexp, 1)
CTSStagCountGR(exampleCAGEexp, "all")
 
CTSStagCountSE(exampleCAGEexp)

}
\seealso{
\code{\link[=getCTSS]{getCTSS()}}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr CTSS methods}
\concept{CAGEr accessor methods}
