% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combineClusters}
\alias{combineClusters}
\alias{combineClusters,RangedSummarizedExperiment,RangedSummarizedExperiment-method}
\title{Combine two CAGE experiments.}
\usage{
combineClusters(object1, object2, ...)

\S4method{combineClusters}{RangedSummarizedExperiment,RangedSummarizedExperiment}(object1, object2, removeIfOverlapping = "none")
}
\arguments{
\item{object1}{RangedSummarizedExperiment: First experiment to be combined.}

\item{object2}{RangedSummarizedExperiment: First experiment to be combined.}

\item{...}{arguments passed to methods.}

\item{removeIfOverlapping}{character: Whether to keep overlapping ranges
('none') or discard from either the first ('object1') or second ('object2')
experiment.}
}
\value{
RangedSummarizedExperiment with merged and sorted ranges (colData and
  metadata are carried over unchanged).
}
\description{
This function can safely combine two CAGE experiments, for example TCs and
enhancers, for later analysis, by making sure no ranges in the final object
are overlapping.
}
\examples{
data(exampleUnidirectional)
data(exampleBidirectional)

# Clusters must have identical colData to be combined:
exampleUnidirectional$totalTags <- NULL

# Combine, keeping potential overlaps
combineClusters(object1=exampleUnidirectional, object2=exampleBidirectional)

# If features overlap, keep only from object1
combineClusters(object1=exampleUnidirectional, object2=exampleBidirectional,
   removeIfOverlapping='object2')

# If features overlap, keep only from object2
combineClusters(object1=exampleUnidirectional, object2=exampleBidirectional,
   removeIfOverlapping='object1')
}
