% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatialIndexPlot}
\alias{spatialIndexPlot}
\title{Generate a visual index of spatial score distributions}
\usage{
spatialIndexPlot(
  scores,
  areas,
  out.file,
  ref.plot = TRUE,
  image.raster = NULL,
  x.col = "array_col",
  y.col = "array_row",
  label.col = "label",
  idSpatial.col = "idSpatial",
  cut.p = 0.01,
  low.color = "royalblue3",
  mid.color = "white",
  high.color = "orange",
  title.fs = 12,
  legend.fs = 10,
  axis.fs = 10,
  label.fs = 12,
  dot.size = 0.25,
  ratio = 1.25,
  base.v = 2.5,
  base.h = 3,
  ref.colors = NULL
)
}
\arguments{
\item{scores}{A matrix of scores, one L-R interaction per row and
spatial locations in the columns. This matrix is typically obtained
from BulkSignalR functions \code{scoreLRGeneSignatures} or \code{scScoring}.}

\item{areas}{A data.frame containing at least the x and y
coordinates of the locations, the unique IDs of spatial locations, and
a tissue label column.}

\item{out.file}{File name for the output PDF.}

\item{ref.plot}{A Boolean indicating whether a reference map of the tissue
with area labels should be plot first.}

\item{image.raster}{Raster object image to plot raw tissue image as
reference.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}

\item{label.col}{Column name in \code{areas} containing area labels.}

\item{idSpatial.col}{Column name in \code{areas} containing the unique
IDs of spatial locations.}

\item{cut.p}{Proportion of top and bottom values for thresholding.}

\item{low.color}{Color for low score values.}

\item{mid.color}{Color for score = 0.}

\item{high.color}{Color for high score values.}

\item{title.fs}{Title font size.}

\item{legend.fs}{Legend items font size.}

\item{axis.fs}{Axis ticks font size.}

\item{label.fs}{Legend titles and axis names font size.}

\item{dot.size}{Dot size.}

\item{ratio}{the vertical/horizontal ratio.}

\item{base.v}{Height of each plot.}

\item{base.h}{Width of each plot.}

\item{ref.colors}{A vector of colors to bypass those automatically chosen
by ggplot2 for the tissue areas in the reference plot.}
}
\value{
Create PDF file and returns `NULL`, invisibly.
}
\description{
Generate an index made of series of small individual spatial score plots
in a PDF. Not limited to BulkSignalR gene signature scores.
}
\details{
A PDF file is created that contains the index.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(bsrinf.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

# generate visual index on disk in pdf file
spatialIndexPlot(scores.red[1:2,], annotation.spa,  
label.col = "ground_truth",
out.file = "spatialIndexPlot")

}
