% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRDataModelComp-class.R
\name{removeClusterComp}
\alias{removeClusterComp}
\alias{removeClusterComp,BSRDataModelComp-method}
\title{Remove a comparison from a BSRDataModelComp object.}
\usage{
\S4method{removeClusterComp}{BSRDataModelComp}(obj, cmp.name)
}
\arguments{
\item{obj}{A BSRDataModelComp object output by
\code{\link{setAs}}.}

\item{cmp.name}{The name of the comparison to remove.}
}
\value{
A BSRDataModelComp object.
}
\description{
Remove a comparison from a BSRDataModelComp object.
}
\details{
Remove the comparison with \code{cmp.name} from the list of
comparisons contained in \code{obj}.
}
\examples{
# prepare data
data(sdc, package = "BulkSignalR")
normal <- grep("^N", names(sdc))
bsrdm <- BSRDataModel(sdc[, -normal])

# define the comparison
bsrdm.comp <- as(bsrdm, "BSRDataModelComp")
colA <- as.integer(1:3)
colB <- as.integer(12:15)
n <- nrow(ncounts(bsrdm.comp))
stats <- data.frame(
    pval = runif(n), logFC = rnorm(n, 0, 2),
    expr = runif(n, 0, 10)
)
rownames(stats) <- rownames(ncounts(bsrdm.comp))
bsrcc <- BSRClusterComp(bsrdm.comp, colA, colB, stats)

bsrdm.comp <- addClusterComp(bsrdm.comp, bsrcc, "random.example")
bsrdm.comp <- removeClusterComp(bsrdm.comp, "random.example")

}
