% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{maxLigandSpatialCounts}
\alias{maxLigandSpatialCounts}
\title{Get maximal ligand expression at nearby locations}
\usage{
maxLigandSpatialCounts(
  bsrdm,
  areas,
  nnn = 4,
  radius = NULL,
  x.col = "array_col",
  y.col = "array_row"
)
}
\arguments{
\item{bsrdm}{A BSRDataModel object containing the expression data to smooth.}

\item{areas}{A data.frame containing at least the x and y
coordinates of the locations.}

\item{nnn}{Number of nearest-neighbor locations to use for smoothing
each location. In case \code{radius} is set, then it is the maximum number
of nearest neighbors within the radius.}

\item{radius}{A maximal distance to include neighbors in the smoothing.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}
}
\value{
A BSRDataModel object containing the maximized ligand expressions.
}
\description{
Get maximal ligand expression at nearby locations
}
\details{
Ligand expression data contained in a BSRDataModel object are
modified to consider the possibility that the ligand of a L-R interaction
might be expressed at nearby locations. This is achieved replacing each
ligand expression by its maximum over the central location and its
neighbors. Since ligands and receptors are never used as gene targets
in computing the receptor downstream signal correlations, this
substitution is compatible with our statistical model. Moreover,
the reciprocal configuration where the ligand is expressed at the
central location and hits a receptors at a neighbor location is
covered when the same ligand maximization scheme is applied to
the neighbor. L-R localization and gene signature scoring is defined
by the location at which the receptor is expressed after applying
this function.

Two strategies are available to identify the neighbors. It is possible to
simply set the number of nearest-neighbors (parameter \code{nnn}). An
alternative consists in providing a distance radius (\code{radius}) along
with a a maximum number of nearest-neighbors within the radius
(\code{nnn.radius}). To properly define the radius, the user must know the
location coordinates. The strategy with the radius enables having corner
locations with two neighbors only and border locations with three
neighbors only, whereas to simply set a maximum of four neighbors for
instance would retrieve the four closest neighbors in every case.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

max.bsrdm <- maxLigandSpatialCounts(bsrdm.spa, annotation.spa,
radius = 1.2, nnn = 4)

}
