% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{getLRIntracellNetwork}
\alias{getLRIntracellNetwork}
\title{Generate a ligand-receptor-downstream signaling network}
\usage{
getLRIntracellNetwork(
  bsrinf,
  pval.thres = NULL,
  qval.thres = NULL,
  min.cor = 0.25,
  max.pval = NULL,
  min.logFC = NULL,
  pos.targets = FALSE,
  neg.targets = FALSE,
  restrict.pw = NULL,
  node.size = 5
)
}
\arguments{
\item{bsrinf}{A BSRInference or BSRInferenceComp object.}

\item{pval.thres}{P-value LR interaction threshold.}

\item{qval.thres}{Q-value LR interaction threshold.}

\item{min.cor}{Minimum correlation required for the target genes.}

\item{max.pval}{Maximum P-value required for the target genes in case
a BSRInferenceComp object is provided.}

\item{min.logFC}{Minimum logFC required for the target genes in case
a BSRInferenceComp object is provided.}

\item{pos.targets}{A logical imposing that all the network targets must
display positive correlation or logFC in case of a BSRInferenceComp object.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative correlation or logFC in case of a BSRInferenceComp object.
Correlations must be <= -min.cor or logFC <= - min.logFC
with this option activated.}

\item{restrict.pw}{A vector of pathway IDs to which receptor downstream
signaling is restricted.}

\item{node.size}{Default node size in the network.}
}
\value{
An \code{igraph} object featuring the ligand-receptor-downstream
signaling network. Default colors and node sizes are assigned,
which can be changed afterwards if necessary.

The target genes to which the \code{min.cor} correlation is imposed are
those listed in \code{tgGenes(bsrinf)}, correlations are in
\code{tgCorr(bsrinf)}.
The construction of shortest paths from the receptors to those selected
targets adds other genes, which were either some targets with too low
correlation or genes along the shortest paths to reach the selected targets.
}
\description{
Generate a ligand-receptor network from a BSRInference object and add
the shortest paths from the receptors to correlated
target genes following Reactome and KEGG pathways.
}
\examples{
data(bsrinf, package = "BulkSignalR")

bsrinf.redBP <- reduceToBestPathway(bsrinf)

pairs <- LRinter(bsrinf.redBP)
top <- unique(pairs[pairs$pval < 1e-20, c("pw.id", "pw.name")])

gLRintra.res <- getLRIntracellNetwork(bsrinf.redBP,
qval.thres = 0.01,
restrict.pw = top[1,]$pw.id
)

# write.graph(gLRintra, file="SDC-LR-intracellular-network.reduced.graphml",
# format="graphml")
}
