% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{chordDiagramLR}
\alias{chordDiagramLR}
\title{Chord Diagram of LR interactions with correlations}
\usage{
chordDiagramLR(
  bsrinf,
  pw.id.filter = NULL,
  qval.thres = 1,
  ligand = NULL,
  receptor = NULL,
  limit = 20
)
}
\arguments{
\item{bsrinf}{A BSRInference object}

\item{pw.id.filter}{One Pathway ID accepted only to}

\item{qval.thres}{Threshold over Q-values.}

\item{ligand}{Ligand
of the LR pair that you want to
highlight in the chord diagram.}

\item{receptor}{Receptor
of the LR pair that you want to highlight
in the chord diagram.}

\item{limit}{Number of interactions you can visualize.}
}
\value{
Circos Plot on the screen or a file
}
\description{
Chord diagram.
}
\examples{
data(bsrinf, package = "BulkSignalR")
chordDiagramLR(bsrinf,
pw.id.filter = "R-HSA-3000178",
limit = 20,
ligand="ADAM15", 
receptor="ITGAV"
)
}
