% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_cIHC}
\alias{BS_cIHC}
\title{Conventional IHC Intrinsic Subtyping (BS_cIHC)}
\usage{
BS_cIHC(se_obj, Subtype = FALSE, hasClinical = FALSE, seed = 118)
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A log2-transformed, normalised expression matrix with
genes (Gene Symbols) as rows and samples as columns.
\item \strong{Column metadata} (\code{colData}): Must include:
\itemize{
\item \code{"PatientID"}: Unique sample or patient identifier.
\item \code{"ER"}: Estrogen receptor status, coded as \code{"ER+"} or \code{"ER-"}.
}
}}

\item{Subtype}{Logical. If \code{TRUE}, returns only the four main subtypes
(Luminal A, Luminal B, HER2-enriched, Basal-like), excluding Normal-like.}

\item{hasClinical}{Logical. If \code{TRUE}, incorporates additional clinical
variables from \code{colData(se_obj)}. Required columns:
\itemize{
\item "TSIZE": Tumor size (0 = \eqn{\le 2}{<= 2} cm; 1 = \eqn{> 2}{> 2} cm).
\item "NODE": Lymph node status (0 = negative; \eqn{\ge 1}{>= 1} = positive). Must be numeric.
}}

\item{seed}{Integer. Random seed for reproducibility of ER-balancing.}
}
\value{
A \code{data.frame} containing intrinsic subtype assignments estimated
using the conventional IHC (cIHC) approach.
}
\description{
Implements the conventional immunohistochemistry-based (cIHC) intrinsic
subtyping approach, which balances cohorts by estrogen receptor (ER) status
before applying gene-expression–based subtyping. This method is useful for
ER-skewed cohorts where assumptions of nearest-centroid classifiers are
violated.
}
\examples{
data("OSLO2EMIT0obj")
res <- BS_cIHC(
    se_obj = OSLO2EMIT0obj$data_input$se_NC,
    Subtype = FALSE,
    hasClinical = FALSE
)

}
\references{
Ciriello G, Gatza ML, Beck AH, Wilkerson MD, Rhie SK, Pastore A, et al.
\emph{Comprehensive Molecular Portraits of Invasive Lobular Breast Cancer.}
Cell. 2015;163(2):506–519.
https://doi.org/10.1016/j.cell.2015.09.033
}
