% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocBuildReportDB.R
\name{biocBuildReportDB}
\alias{biocBuildReportDB}
\title{Parse the Build Report tarball for a Bioconductor release}
\usage{
biocBuildReportDB(
  version = BiocManager::version(),
  pkgType = c("software", "data-experiment", "data-annotation", "workflows"),
  stage.timings = FALSE
)
}
\arguments{
\item{version}{\code{character(1)} or \code{package_version} indicating the
\emph{Bioconductor} version (e.g., "3.22"). Defaults to the "current version"
provided by \code{BiocManager::version()}. The keywords "release" and "devel"
are also accepted.}

\item{pkgType}{\code{character()} The type of packages for which to get
information for. Values can be one or more of the following:
\itemize{
\item \code{software}: Software packages
\item \code{data-experiment}: Experiment data packages
\item \code{data-annotation}: Annotation data packages
\item \code{workflows}: Workflow packages
}}

\item{stage.timings}{\code{logical(1)} Whether to include the start, end, and
elapsed time for each build, check, install stage from each building in
the result (default: FALSE)}
}
\description{
This function parses the Build Report tarball for a Bioconductor
release. By default it will pull all the \code{report.tgz} files for each
Bioconductor package type. The Bioconductor Build System (BBS) Build Report
tarball contains build status information for all packages in a
Bioconductor release. This function is mainly used by \code{\link[=biocBuildReport]{biocBuildReport()}}.
}
